<?php
require_once __DIR__ . '/includes/auth.php';
start_panel_session();
$error = '';

if (is_logged_in()) { header('Location: dashboard.php'); exit; }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $u = trim($_POST['username'] ?? '');
  $p = $_POST['password'] ?? '';
  $t = $_POST['csrf'] ?? '';
  if (!csrf_check($t)) $error = 'Session expired. Refresh and try again.';
  elseif ($u==='' || $p==='') $error = 'Enter username and password.';
  elseif (verify_user($u, $p)) { login_user($u); header('Location: dashboard.php'); exit; }
  else $error = 'Invalid credentials.';
}
?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Login</title>
  <link rel="stylesheet" href="assets/css/bootstrap.css">
  <link rel="stylesheet" href="assets/css/signin.css">
  <link rel="stylesheet" href="assets/css/custom.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
<?php include __DIR__ . '/includes/background.php'; ?>
</head>
<body class="text-center">
  <form class="form-signin" method="post" style="border-radius:14px;background:#0f0f1a;border:1px solid rgba(255,255,255,.08);padding:18px 18px 14px;">
    <h1 class="h5 mb-3 font-weight-normal text-white"><i class="fa fa-lock"></i> Panel Login</h1>
    <?php if ($error): ?>
      <div class="alert alert-danger py-1 px-2" style="border-radius:8px;"><?php echo safe_str($error); ?></div>
    <?php endif; ?>
    <input type="hidden" name="csrf" value="<?php echo safe_str(csrf_token()); ?>">
    <label class="sr-only">Username</label>
    <input name="username" class="form-control" placeholder="Username" required autofocus>
    <label class="sr-only">Password</label>
    <input type="password" name="password" class="form-control" placeholder="Password" required>
    <button class="btn btn-primary btn-block" type="submit">Sign in</button>
    <p class="mt-3 mb-0 text-muted" style="font-size:12px;">Default: admin / changeme123</p>
  </form>
</body>
</html>
