<?php
require_once __DIR__ . '/config.php';

function start_panel_session(): void {
  if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
  }
}
function is_logged_in(): bool {
  start_panel_session();
  return !empty($_SESSION['pp_user']);
}
function require_login(): void {
  if (!is_logged_in()) { header('Location: login.php'); exit; }
}
function csrf_token(): string {
  start_panel_session();
  if (empty($_SESSION['pp_csrf'])) $_SESSION['pp_csrf'] = bin2hex(random_bytes(16));
  return $_SESSION['pp_csrf'];
}
function csrf_check(string $token): bool {
  start_panel_session();
  return hash_equals($_SESSION['pp_csrf'] ?? '', $token);
}
function load_users(): array {
  if (!file_exists(USERS_JSON_PATH)) return [];
  $data = json_decode(file_get_contents(USERS_JSON_PATH), true);
  return is_array($data) ? $data : [];
}
function verify_user(string $username, string $password): bool {
  foreach (load_users() as $u) {
    if (!isset($u['username'], $u['password_hash'])) continue;
    if (hash_equals($u['username'], $username) && password_verify($password, $u['password_hash'])) return true;
  }
  return false;
}
function login_user(string $username): void {
  start_panel_session();
  session_regenerate_id(true);
  $_SESSION['pp_user'] = $username;
}
function logout_user(): void {
  start_panel_session();
  $_SESSION = [];
  if (ini_get('session.use_cookies')) {
    $p = session_get_cookie_params();
    setcookie(session_name(), '', time()-42000, $p['path'], $p['domain'], $p['secure'], $p['httponly']);
  }
  session_destroy();
}
function safe_str(string $s): string { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }
