<?php
require_once __DIR__ . '/includes/auth.php';
require_login();

$message = '';
$imgDir = 'assets/img/';
$logoPath = $imgDir . 'logo.png';
$bgPath   = $imgDir . 'bg.jpg';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

  if (!is_dir(__DIR__ . '/' . $imgDir)) {
    mkdir(__DIR__ . '/' . $imgDir, 0755, true);
  }

  if (!empty($_FILES['logo']['name'])) {
    move_uploaded_file($_FILES['logo']['tmp_name'], __DIR__ . '/' . $logoPath);
    $message = 'Logo updated';
  }

  if (!empty($_FILES['bg']['name'])) {
    move_uploaded_file($_FILES['bg']['tmp_name'], __DIR__ . '/' . $bgPath);
    $message = 'Background updated';
  }
}

$title = 'Appearance';
$active = 'appearance';
include __DIR__ . '/includes/header.php';
?>

<div class="row justify-content-center">
  <div class="col-12 col-md-11 col-lg-10 col-xl-9">

    <div class="card"
         style="background:#0f0f1a;border-radius:20px;border:1px solid rgba(255,255,255,.08)">
      <div class="card-body">

        <h5 class="mb-4">
          <i class="fa fa-paint-brush"></i> Appearance
        </h5>

        <?php if ($message): ?>
          <div class="alert alert-success py-2"><?= $message ?></div>
        <?php endif; ?>

        <form method="post" enctype="multipart/form-data">

          <div class="row">

            <!-- LOGO -->
            <div class="col-md-6">
              <div class="form-group">
                <label class="text-muted" style="font-size:12px;">Panel logo (PNG)</label>

                <?php if (file_exists($logoPath)): ?>
                  <div class="mb-2">
                    <img src="<?= $logoPath ?>?t=<?= time() ?>"
                         style="max-height:60px;background:#111;padding:8px;border-radius:8px">
                  </div>
                <?php endif; ?>

                <input class="form-control" type="file" name="logo" accept="image/png">
              </div>
            </div>

            <!-- BACKGROUND -->
            <div class="col-md-6">
              <div class="form-group">
                <label class="text-muted" style="font-size:12px;">Background image (JPG)</label>

                <?php if (file_exists($bgPath)): ?>
                  <div class="mb-2">
                    <img src="<?= $bgPath ?>?t=<?= time() ?>"
                         style="width:100%;max-height:160px;object-fit:cover;border-radius:12px">
                  </div>
                <?php endif; ?>

                <input class="form-control" type="file" name="bg" accept="image/jpeg,image/jpg">
              </div>
            </div>

          </div>

          <div class="text-right mt-3">
            <button class="btn btn-primary">
              <i class="fa fa-save"></i> Save changes
            </button>
          </div>

        </form>

      </div>
    </div>

  </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
